package fr.asip.cps3.exemple.vues.composants;

import java.awt.Insets;

/**
 * Dfini un style de cellule utilis par le GridBagHelper.
 */
public class StyleCellule {

    /**
     * anchor CENTER, NORTH, NORTHEAST, EAST, SOUTHEAST, SOUTH, SOUTHWEST, WEST, NORTHWEST.
     */
    int anchor;

    /**
     * fill NONE, HORIZONTAL, VERTICAL, BOTH
     */
    int fill;

    /**
     * insets (int top, int left, int bottom, int right)
     */
    Insets insets;

    /**
     * padding X interne
     */
    int ipadx;

    /**
     * padding Y interne
     */
    int ipady;

    /**
     * Espace supplmentaire en X (aucun=0.0 ... tout=1.0)
     */
    double weightx;

    /**
     * Espace supplmentaire en Y (aucun=0.0 ... tout=1.0)
     */
    double weighty;

    /**
     * Constructeur
     * 
     * @param weightx espace supplmentaire en X (aucun=0.0 ... tout=1.0)
     * @param weighty espace supplmentaire en Y (aucun=0.0 ... tout=1.0)
     * @param anchor position si le composant n'occupe par la cellule entire:
     * <br><code>
     * --------------------------------------------------<br>
     * |FIRST_LINE_START...PAGE_START.....FIRST_LINE_END|<br>
     * |LINE_START...........CENTER.............LINE_END|<br>
     * |LAST_LINE_START.....PAGE_END.......LAST_LINE_END|<br>
     * --------------------------------------------------<br>
     * <code>
     * @param fill NONE, HORIZONTAL, VERTICAL, BOTH
     * @param insets (int top, int left, int bottom, int right)
     * @param ipadx padding X interne
     * @param ipady padding Y interne
     */
    public StyleCellule(double weightx, double weighty,
        int anchor, int fill, Insets insets, int ipadx, int ipady) {
        super();
        this.fill = fill;
        this.ipadx = ipadx;
        this.ipady = ipady;
        this.insets = insets;
        this.anchor = anchor;
        this.weightx = weightx;
        this.weighty = weighty;
    }

}
